//
//  MCFormattingAgent.h
//  BISubstrate
//
//  Created by Alykhan Jetha on 10-01-25.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

/*!
 MCFormatting agent uses the interceptor pattern to provide a way to get formatted values from a base object without having to write a method for each.
 
 For example: An object responds to "total". To get a formatter method, you'd have to implement something like "formattedTotal". For one method that's ok, for dozens, it's a pain. With this pattern, you would do the following: valueForKeyPath:@"baseCurrencyFormatting.total" where baseCurrencyAgent is one of these objects.
 
 You must implement "baseCurrencyFormatting" (probably in your base class) and that's it.
 
 This class is not called a formatter because it would be confuse with actual formatter, yet formatting is exactly what it does.
 SourceObject is a weak reference so that we don't create retain cycles.
 */

@interface MCFormattingAgent : NSObject {
	NSFormatter *formatter;
	id sourceObject; // weak ref
}

- (id)initWithFormatter:(NSFormatter *)aFormatter sourceObject:(id)anObj;

/*!
 For situation when a formatter can change within a session but you don't want to re-instantiate this object a million times
 */
- (void)setFormatter:(NSFormatter *)aFormatter;

@end
